# Federated Learning-Based Intrusion Detection System for IoHT  Devices
The goal of this work is to develop a federated learning-based Deep Neural Network (DNN-FL) as the classifier for each client to analyze network traffic and detect attacks in the IoHT environment. We compare results with three different deep learning methods (centralized method).

# Dataset Used
- wustl-ehms-2020 https://www.cse.wustl.edu/~jain/ehms/index.html
- ECU-IoHT  https://ro.ecu.edu.au/datasets/48/
# Citation

MOSAIYEBZADEH, F. ; POURIYEH, S. ; PARIZI, R. M. ; HAN, M. ; BATISTA, D. M. . Intrusion Detection System for IoHT Devices using Federated Learning. In: 
AidTSP 2023: International Workshop on AI-driven Trustworthy, Secure, and Privacy-Preserving Computing, 2023. Proceedings of the IEEE INFOCOM Workshops,
2023.
https://ieeexplore.ieee.org/abstract/document/10225932

# Algorithms Used
Decentralized method:
- DNN-FL (Deep Neural Network)

Centralized methods:

- DNN (Deep Neural Network)
- LSTM (Long Short-Term Memory) 
- CNN-LSTM (mix of Convolutional and Recurrent Neural Networks)

# How to Run it:

To run the Colab notebook code, you must first download dataset files and two notebooks (DNN_FL_based_IDS.ipynb, Wustl_ECU_ICU_Centralized_Learning.ipynb). Then upload them on your Google collaborator ( in the same directory).

